/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm.metadata;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.asto.rx.RxStorage;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.helm.ChartYaml;
import com.artipie.helm.TgzArchive;
import com.artipie.helm.metadata.IndexYamlMapping;
import com.artipie.helm.misc.DateTimeNow;
import io.reactivex.Completable;
import io.reactivex.Single;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.yaml.snakeyaml.Yaml;

public final class IndexYaml {
    public static final Key INDEX_YAML = new Key.From("index.yaml");
    private final RxStorage storage;

    public IndexYaml(Storage storage) {
        this.storage = new RxStorageWrapper(storage);
    }

    public Completable update(TgzArchive arch) {
        return this.indexFromStrg((Single<Map<String, Object>>)Single.just(IndexYaml.empty())).map(idx -> IndexYaml.update(idx, arch)).flatMapCompletable(this::indexToStorage);
    }

    public Completable deleteByName(String name) {
        return this.indexFromStrg(IndexYaml.notFoundException()).map(idx -> {
            new IndexYamlMapping((Map<String, Object>)idx).entries().remove(name);
            return idx;
        }).flatMapCompletable(this::indexToStorage);
    }

    public Completable deleteByNameAndVersion(String name, String version) {
        return this.indexFromStrg(IndexYaml.notFoundException()).map(idx -> {
            IndexYamlMapping mapping = new IndexYamlMapping((Map<String, Object>)idx);
            List<Map<String, Object>> newvers = mapping.byChart(name).stream().filter(entry -> !entry.get("version").equals(version)).collect(Collectors.toList());
            mapping.entries().remove(name);
            if (!newvers.isEmpty()) {
                mapping.addChartVersions(name, newvers);
            }
            return idx;
        }).flatMapCompletable(this::indexToStorage);
    }

    private static Map<String, Object> empty() {
        HashMap<String, Object> res = new HashMap<String, Object>(3);
        res.put("apiVersion", "v1");
        res.put("entries", new HashMap(0));
        res.put("generated", new DateTimeNow().asString());
        return res;
    }

    private static <T> Single<T> notFoundException() {
        return Single.error((Throwable)new FileNotFoundException(String.format("File '%s' is not found", INDEX_YAML)));
    }

    private static Map<String, Object> update(Map<String, Object> index, TgzArchive tgz) {
        HashMap<String, Object> copy = new HashMap<String, Object>(index);
        IndexYamlMapping yaml = new IndexYamlMapping(copy);
        ChartYaml chart = tgz.chartYaml();
        if (!yaml.byChartAndVersion(chart.name(), chart.version()).isPresent()) {
            yaml.addChartVersions(chart.name(), Collections.singletonList(tgz.metadata(Optional.empty())));
        }
        return copy;
    }

    private Single<Map<String, Object>> indexFromStrg(Single<Map<String, Object>> notexist) {
        return this.storage.exists(INDEX_YAML).flatMap(exist -> {
            Single result = exist != false ? this.storage.value(INDEX_YAML).flatMap(content -> new Concatenation((Publisher)content).single()).map(buf -> new String(new Remaining(buf).bytes())).map(content -> (Map)new Yaml().load(content)) : notexist;
            return result;
        });
    }

    private Completable indexToStorage(Map<String, Object> index) {
        return this.storage.save(INDEX_YAML, (Content)new Content.From(new IndexYamlMapping(index).toString().getBytes(StandardCharsets.UTF_8)));
    }
}

