/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.helm.ChartYaml;
import com.artipie.helm.TgzArchive;
import com.artipie.helm.metadata.IndexYamlMapping;
import com.artipie.helm.metadata.ParsedChartName;
import com.artipie.helm.metadata.YamlWriter;
import com.artipie.helm.misc.DateTimeNow;
import com.artipie.helm.misc.EmptyIndex;
import com.artipie.helm.misc.SpaceInBeginning;
import com.artipie.http.misc.TokenizerFlatProc;
import hu.akarnokd.rxjava2.interop.FlowableInterop;
import io.reactivex.Flowable;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

interface AddWriter {
    public CompletionStage<Void> add(Key var1, Path var2, Map<String, Set<Pair<String, ChartYaml>>> var3);

    public CompletionStage<Void> addTrustfully(Path var1, SortedSet<Key> var2);

    public static final class Asto
    implements AddWriter {
        static final String VRSNS = "version:";
        static final String ENTRS = "entries:";
        private final Storage storage;

        Asto(Storage storage) {
            this.storage = storage;
        }

        @Override
        public CompletionStage<Void> add(Key source, Path out, Map<String, Set<Pair<String, ChartYaml>>> pckgs) {
            return CompletableFuture.allOf(new CompletableFuture[0]).thenCompose(none -> {
                try {
                    BufferedWriter bufw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(out, new OpenOption[0])));
                    TokenizerFlatProc target = new TokenizerFlatProc("\n");
                    return this.contentOfIndex(source).thenAccept(cont -> cont.subscribe((Subscriber)target)).thenCompose(noth -> ((CompletionStage)Flowable.fromPublisher((Publisher)target).map(buf -> new String(new Remaining(buf).bytes())).scan((Object)new ScanContext(bufw, 2), (ctx, curr) -> {
                        String prevname = ((ScanContext)ctx).name;
                        int pos = new SpaceInBeginning((String)curr).last();
                        if (pos > 0 && prevname.isEmpty()) {
                            ((ScanContext)ctx).setWriter(new YamlWriter(bufw, pos));
                        }
                        if (curr.startsWith(ENTRS)) {
                            ((ScanContext)ctx).setEntries(true);
                        } else if (pos == 0 && !curr.isEmpty()) {
                            ((ScanContext)ctx).setEntries(false);
                        }
                        if (((ScanContext)ctx).inentries) {
                            Asto.throwIfVersionExists(curr, prevname, pckgs);
                        }
                        if (new ParsedChartName((String)curr).valid() && ((ScanContext)ctx).inentries && pos == ((ScanContext)ctx).wrtr.indent()) {
                            if (!prevname.isEmpty()) {
                                Asto.writeRemainedVersions(((ScanContext)ctx).name, pckgs, ((ScanContext)ctx).wrtr);
                            }
                            ((ScanContext)ctx).setName(curr.replace(":", "").trim());
                        } else if (!((ScanContext)ctx).inentries) {
                            ((ScanContext)ctx).setName("");
                        }
                        if (!prevname.isEmpty() && pos == 0) {
                            Asto.writeRemainedVersions(prevname, pckgs, ((ScanContext)ctx).wrtr);
                            Asto.writeRemainedChartsAfterCopyIdx(pckgs, ((ScanContext)ctx).wrtr);
                        }
                        ((ScanContext)ctx).wrtr.writeAndReplaceTagGenerated((String)curr);
                        return ctx;
                    }).to(FlowableInterop.last())).thenCompose(ctx -> {
                        if (((ScanContext)ctx).inentries) {
                            Asto.writeRemainedChartsAfterCopyIdx(pckgs, ((ScanContext)ctx).wrtr);
                        }
                        try {
                            bufw.close();
                        }
                        catch (IOException exc) {
                            throw new ArtipieIOException(exc);
                        }
                        return CompletableFuture.allOf(new CompletableFuture[0]);
                    }));
                }
                catch (IOException exc) {
                    throw new ArtipieIOException(exc);
                }
            });
        }

        @Override
        public CompletionStage<Void> addTrustfully(Path out, SortedSet<Key> charts) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    String[] lines;
                    BufferedWriter bufw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(out, new OpenOption[0])));
                    YamlWriter writer = new YamlWriter(bufw, 2);
                    for (String line : lines = new EmptyIndex().asString().split("\n")) {
                        if (line.isEmpty()) continue;
                        writer.writeLine(line, 0);
                    }
                    CompletableFuture result = new CompletableFuture();
                    this.writeChartsToIndex(charts, writer).handle((noth, thr) -> {
                        if (thr == null) {
                            result.complete(null);
                        } else {
                            result.completeExceptionally((Throwable)thr);
                        }
                        try {
                            bufw.close();
                        }
                        catch (IOException exc) {
                            throw new ArtipieIOException(exc);
                        }
                        return null;
                    });
                    return result;
                }
                catch (IOException exc) {
                    throw new ArtipieIOException(exc);
                }
            }).thenCompose(Function.identity());
        }

        private CompletionStage<Content> contentOfIndex(Key source) {
            return this.storage.exists(source).thenCompose(exists -> {
                CompletableFuture<Content> res = exists != false ? this.storage.value(source) : CompletableFuture.completedFuture(new EmptyIndex().asContent());
                return res;
            });
        }

        private CompletableFuture<Void> writeChartsToIndex(SortedSet<Key> charts, YamlWriter writer) {
            AtomicReference prev = new AtomicReference();
            CompletionStage<Void> future = CompletableFuture.allOf(new CompletableFuture[0]);
            for (Key key : charts) {
                future = future.thenCompose(noth -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.storage.value(key).thenApply(PublisherAs::new)).thenCompose(PublisherAs::bytes)).thenApply(TgzArchive::new)).thenAccept(tgz -> {
                    HashMap<String, Object> fields = new HashMap<String, Object>(tgz.chartYaml().fields());
                    fields.putAll(tgz.metadata(Optional.empty()));
                    fields.put("created", new DateTimeNow().asString());
                    String name = (String)fields.get("name");
                    try {
                        String[] splitted;
                        if (!name.equals(prev.get())) {
                            writer.writeLine(String.format("%s:", name), 1);
                        }
                        prev.set(name);
                        writer.writeLine("-", 1);
                        for (String line : splitted = new ChartYaml(fields).toString().split("\n")) {
                            writer.writeLine(line, 2);
                        }
                    }
                    catch (IOException exc) {
                        throw new ArtipieIOException(exc);
                    }
                }));
            }
            return future;
        }

        private static void throwIfVersionExists(String line, String name, Map<String, Set<Pair<String, ChartYaml>>> pckgs) {
            if (line.trim().startsWith(VRSNS)) {
                String vers = line.trim().replace(VRSNS, "").trim();
                if (pckgs.containsKey(name) && pckgs.get(name).stream().anyMatch(pair -> ((String)pair.getLeft()).equals(vers))) {
                    throw new IllegalStateException(String.format("Failed to write to index `%s` with version `%s`", name, vers));
                }
            }
        }

        private static void writeRemainedVersions(String name, Map<String, Set<Pair<String, ChartYaml>>> pckgs, YamlWriter writer) throws IOException {
            if (name != null && pckgs.containsKey(name)) {
                for (Pair<String, ChartYaml> pair : pckgs.get(name)) {
                    writer.writeLine("-", 2);
                    String str = new IndexYamlMapping(((ChartYaml)pair.getRight()).fields()).toString();
                    for (String entry : str.split("[\\n\\r]+")) {
                        writer.writeLine(entry, 3);
                    }
                }
                pckgs.remove(name);
            }
        }

        private static void writeRemainedChartsAfterCopyIdx(Map<String, Set<Pair<String, ChartYaml>>> pckgs, YamlWriter writer) {
            pckgs.forEach((chart, pairs) -> {
                try {
                    writer.writeLine(String.format("%s:", chart), 1);
                    for (Pair pair : pairs) {
                        String[] lines;
                        writer.writeLine("- ", 2);
                        String yaml = new IndexYamlMapping(((ChartYaml)pair.getRight()).fields()).toString();
                        for (String line : lines = yaml.split("[\\n\\r]+")) {
                            writer.writeLine(line, 3);
                        }
                    }
                }
                catch (IOException exc) {
                    throw new ArtipieIOException(exc);
                }
            });
            pckgs.clear();
        }

        private static final class ScanContext {
            private boolean inentries;
            private YamlWriter wrtr;
            private String name;

            ScanContext(BufferedWriter bufw, int indent) {
                this.wrtr = new YamlWriter(bufw, indent);
                this.name = "";
            }

            private void setEntries(boolean inentrs) {
                this.inentries = inentrs;
            }

            private void setName(String cname) {
                this.name = cname;
            }

            private void setWriter(YamlWriter writer) {
                this.wrtr = writer;
            }
        }
    }
}

