/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.helm.metadata;

import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.helm.metadata.ParsedChartName;
import com.artipie.helm.misc.SpaceInBeginning;
import com.artipie.http.misc.TokenizerFlatProc;
import hu.akarnokd.rxjava2.interop.FlowableInterop;
import io.reactivex.Flowable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public interface Index {
    public CompletionStage<Map<String, Set<String>>> versionsByPackages(Key var1);

    public static final class WithBreaks
    implements Index {
        static final String VRSNS = "version:";
        static final String ENTRS = "entries:";
        private final Storage storage;

        public WithBreaks(Storage storage) {
            this.storage = storage;
        }

        @Override
        public CompletionStage<Map<String, Set<String>>> versionsByPackages(Key idx) {
            return this.storage.exists(idx).thenCompose(exists -> {
                CompletionStage<Map<String, Set<String>>> res = exists != false ? this.versionsByPckgs(idx) : CompletableFuture.completedFuture(new HashMap());
                return res;
            });
        }

        private CompletionStage<Map<String, Set<String>>> versionsByPckgs(Key idx) {
            TokenizerFlatProc target = new TokenizerFlatProc("\n");
            return ((CompletableFuture)this.storage.value(idx).thenAccept(cont -> cont.subscribe((Subscriber)target))).thenCompose(noth -> ((CompletionStage)Flowable.fromPublisher((Publisher)target).map(buf -> new String(new Remaining(buf).bytes())).scan((Object)new ScanContext(), (ctx, curr) -> {
                int pos = new SpaceInBeginning((String)curr).last();
                if (((ScanContext)ctx).indent == 0) {
                    ((ScanContext)ctx).setIndent(pos);
                }
                if (curr.startsWith(ENTRS)) {
                    ((ScanContext)ctx).setEntries(true);
                } else if (pos == 0) {
                    ((ScanContext)ctx).setEntries(false);
                }
                if (new ParsedChartName((String)curr).valid() && pos == ((ScanContext)ctx).indent) {
                    ((ScanContext)ctx).setName(curr.replace(":", "").trim());
                } else if (((ScanContext)ctx).inentries) {
                    if (curr.trim().startsWith(VRSNS)) {
                        ((ScanContext)ctx).addChartVersion(curr.replace(VRSNS, "").trim());
                    }
                } else {
                    ((ScanContext)ctx).setName("");
                }
                return ctx;
            }).to(FlowableInterop.last())).thenApply(rec$ -> ((ScanContext)rec$).chartVersions()));
        }

        private static final class ScanContext {
            private final Map<String, Set<String>> vrsns = new HashMap<String, Set<String>>();
            private boolean inentries;
            private int indent;
            private String name;

            private ScanContext() {
            }

            private void setEntries(boolean inentrs) {
                this.inentries = inentrs;
            }

            private void setIndent(int cindent) {
                this.indent = cindent;
            }

            private void setName(String cname) {
                this.name = cname;
            }

            private void addChartVersion(String version) {
                Set existed = this.vrsns.computeIfAbsent(this.name, none -> new HashSet());
                existed.add(version);
                this.vrsns.put(this.name, existed);
            }

            private Map<String, Set<String>> chartVersions() {
                return Collections.unmodifiableMap(this.vrsns);
            }
        }
    }
}

