/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.hex.http;

import com.artipie.ArtipieException;
import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.OneTimePublisher;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.hex.proto.generated.PackageOuterClass;
import com.artipie.hex.proto.generated.SignedOuterClass;
import com.artipie.hex.tarball.MetadataConfig;
import com.artipie.hex.tarball.TarReader;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.Header;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsFull;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithStatus;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.reactivestreams.Publisher;

public final class UploadSlice
implements Slice {
    static final Pattern PUBLISH = Pattern.compile("(/repos/)?(?<org>.+)?/publish");
    static final Pattern QUERY = Pattern.compile("replace=(?<replace>true|false)");
    private final Storage storage;

    public UploadSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RsWithStatus res;
        URI uri = new RequestLineFrom(line).uri();
        String path = Objects.nonNull(uri.getPath()) ? uri.getPath() : "";
        Matcher pathmatcher = PUBLISH.matcher(path);
        String query = Objects.nonNull(uri.getQuery()) ? uri.getQuery() : "";
        Matcher querymatcher = QUERY.matcher(query);
        if (pathmatcher.matches() && querymatcher.matches()) {
            boolean replace = Boolean.parseBoolean(querymatcher.group("replace"));
            AtomicReference name = new AtomicReference();
            AtomicReference version = new AtomicReference();
            AtomicReference innerchcksum = new AtomicReference();
            AtomicReference outerchcksum = new AtomicReference();
            AtomicReference tarcontent = new AtomicReference();
            AtomicReference releases = new AtomicReference();
            AtomicReference packagekey = new AtomicReference();
            res = new AsyncResponse(UploadSlice.asBytes(body).thenAccept(bytes -> UploadSlice.readVarsFromTar(bytes, name, version, innerchcksum, outerchcksum, tarcontent, packagekey)).thenCompose(nothing -> this.storage.exists((Key)packagekey.get())).thenCompose(packageExists -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.readReleasesListFromStorage((Boolean)packageExists, releases, packagekey).thenAccept(nothing -> UploadSlice.handleReleases(releases, replace, version))).thenApply(nothing -> UploadSlice.constructSignedPackage(name, version, innerchcksum, outerchcksum, releases))).thenCompose(signedPackage -> this.saveSignedPackageToStorage(packagekey, (SignedOuterClass.Signed)signedPackage))).thenCompose(nothing -> this.saveTarContentToStorage(name, version, tarcontent))).handle((content, throwable) -> {
                Object result = throwable == null ? new RsFull(RsStatus.CREATED, (Iterable)new Headers.From((Map.Entry)new Header("Content-Type", "application/vnd.hex+erlang; charset=UTF-8")), Content.EMPTY) : new RsWithBody((Response)new RsWithStatus(RsStatus.INTERNAL_ERROR), throwable.getMessage().getBytes());
                return result;
            }));
        } else {
            res = new RsWithStatus(RsStatus.BAD_REQUEST);
        }
        return res;
    }

    private static void handleReleases(AtomicReference<List<PackageOuterClass.Release>> releases, boolean replace, AtomicReference<String> version) throws ArtipieException {
        List<PackageOuterClass.Release> releaseslist = releases.get();
        if (releaseslist.isEmpty()) {
            return;
        }
        boolean versionexist = false;
        ArrayList<PackageOuterClass.Release> filtered = new ArrayList<PackageOuterClass.Release>(releaseslist.size());
        for (PackageOuterClass.Release release : releaseslist) {
            if (release.getVersion().equals(version.get())) {
                versionexist = true;
                continue;
            }
            filtered.add(release);
        }
        if (versionexist && !replace) {
            throw new ArtipieException(String.format("Version %s already exists.", version.get()));
        }
        if (replace) {
            releases.set(filtered);
        }
    }

    private static void readVarsFromTar(byte[] tar, AtomicReference<String> name, AtomicReference<String> version, AtomicReference<String> innerchecksum, AtomicReference<String> outerchecksum, AtomicReference<byte[]> tarcontent, AtomicReference<Key> packagekey) {
        tarcontent.set(tar);
        outerchecksum.set(DigestUtils.sha256Hex((byte[])tar));
        TarReader reader = new TarReader(tar);
        reader.readEntryContent("metadata.config").map(MetadataConfig::new).map(metadataConfig -> {
            String app = metadataConfig.app();
            name.set(app);
            packagekey.set((Key)new Key.From(new String[]{"packages", app}));
            version.set(metadataConfig.version());
            return metadataConfig;
        }).orElseThrow();
        reader.readEntryContent("CHECKSUM").map(checksumBytes -> {
            innerchecksum.set(new String((byte[])checksumBytes));
            return checksumBytes;
        }).orElseThrow();
    }

    private CompletableFuture<Void> readReleasesListFromStorage(Boolean packageexist, AtomicReference<List<PackageOuterClass.Release>> releases, AtomicReference<Key> packagekey) {
        CompletionStage<Object> future;
        if (packageexist.booleanValue()) {
            future = ((CompletableFuture)this.storage.value(packagekey.get()).thenCompose(UploadSlice::asBytes)).thenAccept(gzippedBytes -> {
                byte[] bytes = UploadSlice.decompressGzip(gzippedBytes);
                try {
                    SignedOuterClass.Signed signed = SignedOuterClass.Signed.parseFrom(bytes);
                    PackageOuterClass.Package pkg = PackageOuterClass.Package.parseFrom(signed.getPayload());
                    releases.set(pkg.getReleasesList());
                }
                catch (InvalidProtocolBufferException ipbex) {
                    throw new ArtipieException("Cannot parse package", (Throwable)ipbex);
                }
            });
        } else {
            releases.set(Collections.emptyList());
            future = CompletableFuture.completedFuture(null);
        }
        return future;
    }

    private static SignedOuterClass.Signed constructSignedPackage(AtomicReference<String> name, AtomicReference<String> version, AtomicReference<String> innerchecksum, AtomicReference<String> outerchecksum, AtomicReference<List<PackageOuterClass.Release>> releases) {
        PackageOuterClass.Release release;
        try {
            release = PackageOuterClass.Release.newBuilder().setVersion(version.get()).setInnerChecksum(ByteString.copyFrom((byte[])Hex.decodeHex((String)innerchecksum.get()))).setOuterChecksum(ByteString.copyFrom((byte[])Hex.decodeHex((String)outerchecksum.get()))).build();
        }
        catch (DecoderException dex) {
            throw new ArtipieException("Cannot decode hexed checksum", (Throwable)dex);
        }
        PackageOuterClass.Package pckg = PackageOuterClass.Package.newBuilder().setName(name.get()).setRepository("artipie").addAllReleases((Iterable<? extends PackageOuterClass.Release>)releases.get()).addReleases(release).build();
        return SignedOuterClass.Signed.newBuilder().setPayload(ByteString.copyFrom((byte[])pckg.toByteArray())).setSignature(ByteString.EMPTY).build();
    }

    private CompletableFuture<Void> saveSignedPackageToStorage(AtomicReference<Key> packagekey, SignedOuterClass.Signed signed) {
        return this.storage.save(packagekey.get(), (Content)new Content.From(UploadSlice.compressGzip(signed.toByteArray())));
    }

    private CompletableFuture<Void> saveTarContentToStorage(AtomicReference<String> name, AtomicReference<String> version, AtomicReference<byte[]> tarcontent) {
        return this.storage.save((Key)new Key.From(new String[]{"tarballs", String.format("%s-%s.tar", name, version)}), (Content)new Content.From(tarcontent.get()));
    }

    private static CompletionStage<byte[]> asBytes(Publisher<ByteBuffer> body) {
        return ((CompletionStage)new Concatenation((Publisher)new OneTimePublisher(body)).single().to(SingleInterop.get())).thenApply(Remaining::new).thenApply(Remaining::bytes);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] compressGzip(byte[] data) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);){
            byte[] byArray;
            try (GZIPOutputStream gzipos = new GZIPOutputStream((OutputStream)baos, data.length);){
                gzipos.write(data);
                gzipos.finish();
                baos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException ioex) {
            throw new ArtipieException("Error when compressing gzip archive", (Throwable)ioex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] decompressGzip(byte[] gzippedbytes) {
        try (GZIPInputStream gzipis = new GZIPInputStream((InputStream)new ByteArrayInputStream(gzippedbytes), gzippedbytes.length);){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(gzippedbytes.length);){
                baos.writeBytes(gzipis.readAllBytes());
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException ioex) {
            throw new ArtipieException("Error when decompressing gzip archive", (Throwable)ioex);
        }
    }
}

