/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.hex.tarball;

import com.artipie.ArtipieException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class TarReader {
    public static final String CHECKSUM = "CHECKSUM";
    public static final String METADATA = "metadata.config";
    private final byte[] bytes;

    public TarReader(byte[] bytes) {
        this.bytes = Arrays.copyOf(bytes, bytes.length);
    }

    public Optional<byte[]> readEntryContent(String name) {
        byte[] content = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(this.bytes);
             TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)bis);){
            TarArchiveEntry entry;
            while ((entry = (TarArchiveEntry)tar.getNextEntry()) != null) {
                int len;
                if (!name.equals(entry.getName())) continue;
                ByteArrayOutputStream entrycontent = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((len = tar.read(buf)) != -1) {
                    entrycontent.write(buf, 0, len);
                }
                content = entrycontent.toByteArray();
                break;
            }
        }
        catch (IOException ioex) {
            throw new ArtipieException(String.format("Cannot read content of '%s' from tar-archive", name), (Throwable)ioex);
        }
        return Optional.ofNullable(content);
    }
}

