/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.hex.utils;

import com.artipie.ArtipieException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class Gzip {
    private final byte[] data;

    public Gzip(byte[] data) {
        this.data = Arrays.copyOf(data, data.length);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] compress() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(this.data.length);){
            byte[] byArray;
            try (GZIPOutputStream gzipos = new GZIPOutputStream((OutputStream)baos, this.data.length);){
                gzipos.write(this.data);
                gzipos.finish();
                baos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException ioex) {
            throw new ArtipieException("Error when compressing gzip archive", (Throwable)ioex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] decompress() {
        try (GZIPInputStream gzipis = new GZIPInputStream((InputStream)new ByteArrayInputStream(this.data), this.data.length);){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(this.data.length);){
                baos.writeBytes(gzipis.readAllBytes());
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException ioex) {
            throw new ArtipieException("Error when decompressing gzip archive", (Throwable)ioex);
        }
    }
}

