/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.client;

import java.util.Optional;

public interface Settings {
    public Optional<Proxy> proxy();

    public boolean trustAll();

    public boolean followRedirects();

    public static final class WithFollowRedirects
    implements Settings {
        private final Settings origin;
        private final boolean redirect;

        public WithFollowRedirects(boolean redirect) {
            this(new Default(), redirect);
        }

        public WithFollowRedirects(Settings origin, boolean redirect) {
            this.origin = origin;
            this.redirect = redirect;
        }

        @Override
        public Optional<Proxy> proxy() {
            return this.origin.proxy();
        }

        @Override
        public boolean trustAll() {
            return this.origin.trustAll();
        }

        @Override
        public boolean followRedirects() {
            return this.redirect;
        }
    }

    public static final class WithTrustAll
    implements Settings {
        private final Settings origin;
        private final boolean trust;

        public WithTrustAll(boolean trust) {
            this(new Default(), trust);
        }

        public WithTrustAll(Settings origin, boolean trust) {
            this.origin = origin;
            this.trust = trust;
        }

        @Override
        public Optional<Proxy> proxy() {
            return this.origin.proxy();
        }

        @Override
        public boolean trustAll() {
            return this.trust;
        }

        @Override
        public boolean followRedirects() {
            return this.origin.followRedirects();
        }
    }

    public static final class WithProxy
    implements Settings {
        private final Settings origin;
        private final Proxy prx;

        public WithProxy(Proxy prx) {
            this(new Default(), prx);
        }

        public WithProxy(Settings origin, Proxy prx) {
            this.origin = origin;
            this.prx = prx;
        }

        @Override
        public Optional<Proxy> proxy() {
            return Optional.of(this.prx);
        }

        @Override
        public boolean trustAll() {
            return this.origin.trustAll();
        }

        @Override
        public boolean followRedirects() {
            return this.origin.followRedirects();
        }
    }

    public static final class Default
    implements Settings {
        @Override
        public Optional<Proxy> proxy() {
            return Optional.empty();
        }

        @Override
        public boolean trustAll() {
            return false;
        }

        @Override
        public boolean followRedirects() {
            return false;
        }
    }

    public static interface Proxy {
        public boolean secure();

        public String host();

        public int port();

        public static final class Simple
        implements Proxy {
            private final boolean secure;
            private final String host;
            private final int port;

            public Simple(boolean secure, String host, int port) {
                this.secure = secure;
                this.host = host;
                this.port = port;
            }

            @Override
            public boolean secure() {
                return this.secure;
            }

            @Override
            public String host() {
                return this.host;
            }

            @Override
            public int port() {
                return this.port;
            }
        }
    }
}

