/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.client.jetty;

import com.artipie.http.Slice;
import com.artipie.http.client.ClientSlices;
import com.artipie.http.client.Settings;
import com.artipie.http.client.jetty.JettyClientSlice;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public final class JettyClientSlices
implements ClientSlices {
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private final HttpClient clnt;

    public JettyClientSlices() {
        this(new Settings.Default());
    }

    public JettyClientSlices(Settings settings) {
        this.clnt = JettyClientSlices.create(settings);
    }

    public HttpClient client() {
        return this.clnt;
    }

    public void start() throws Exception {
        this.clnt.start();
    }

    public void stop() throws Exception {
        this.clnt.stop();
    }

    @Override
    public Slice http(String host) {
        return this.slice(false, host, 80);
    }

    @Override
    public Slice http(String host, int port) {
        return this.slice(false, host, port);
    }

    @Override
    public Slice https(String host) {
        return this.slice(true, host, 443);
    }

    @Override
    public Slice https(String host, int port) {
        return this.slice(true, host, port);
    }

    private Slice slice(boolean secure, String host, int port) {
        return new JettyClientSlice(this.clnt, secure, host, port);
    }

    private static HttpClient create(Settings settings) {
        HttpClient result = new HttpClient((SslContextFactory)new SslContextFactory.Client(settings.trustAll()));
        settings.proxy().ifPresent(proxy -> result.getProxyConfiguration().getProxies().add(new HttpProxy(new Origin.Address(proxy.host(), proxy.port()), proxy.secure())));
        result.setFollowRedirects(settings.followRedirects());
        if (settings.connectTimeout() <= 0L) {
            result.setConnectBlocking(true);
        }
        result.setConnectTimeout(settings.connectTimeout());
        result.setIdleTimeout(settings.idleTimeout());
        return result;
    }
}

