/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.client;

import java.util.Optional;
import java.util.concurrent.TimeUnit;

public interface Settings {
    public Optional<Proxy> proxy();

    public boolean trustAll();

    public boolean followRedirects();

    public long connectTimeout();

    public long idleTimeout();

    public static final class WithIdleTimeout
    implements Settings {
        private final Settings origin;
        private final long millis;

        public WithIdleTimeout(long timeout, TimeUnit unit) {
            this(unit.toMillis(timeout));
        }

        public WithIdleTimeout(Settings origin, long timeout, TimeUnit unit) {
            this(origin, unit.toMillis(timeout));
        }

        public WithIdleTimeout(long millis) {
            this(new Default(), millis);
        }

        public WithIdleTimeout(Settings origin, long millis) {
            this.origin = origin;
            this.millis = millis;
        }

        @Override
        public Optional<Proxy> proxy() {
            return this.origin.proxy();
        }

        @Override
        public boolean trustAll() {
            return this.origin.trustAll();
        }

        @Override
        public boolean followRedirects() {
            return this.origin.followRedirects();
        }

        @Override
        public long connectTimeout() {
            return this.origin.connectTimeout();
        }

        @Override
        public long idleTimeout() {
            return this.millis;
        }
    }

    public static final class WithConnectTimeout
    implements Settings {
        private final Settings origin;
        private final long millis;

        public WithConnectTimeout(long timeout, TimeUnit unit) {
            this(unit.toMillis(timeout));
        }

        public WithConnectTimeout(Settings origin, long timeout, TimeUnit unit) {
            this(origin, unit.toMillis(timeout));
        }

        public WithConnectTimeout(long millis) {
            this(new Default(), millis);
        }

        public WithConnectTimeout(Settings origin, long millis) {
            this.origin = origin;
            this.millis = millis;
        }

        @Override
        public Optional<Proxy> proxy() {
            return this.origin.proxy();
        }

        @Override
        public boolean trustAll() {
            return this.origin.trustAll();
        }

        @Override
        public boolean followRedirects() {
            return this.origin.followRedirects();
        }

        @Override
        public long connectTimeout() {
            return this.millis;
        }

        @Override
        public long idleTimeout() {
            return this.origin.idleTimeout();
        }
    }

    public static final class WithFollowRedirects
    implements Settings {
        private final Settings origin;
        private final boolean redirect;

        public WithFollowRedirects(boolean redirect) {
            this(new Default(), redirect);
        }

        public WithFollowRedirects(Settings origin, boolean redirect) {
            this.origin = origin;
            this.redirect = redirect;
        }

        @Override
        public Optional<Proxy> proxy() {
            return this.origin.proxy();
        }

        @Override
        public boolean trustAll() {
            return this.origin.trustAll();
        }

        @Override
        public boolean followRedirects() {
            return this.redirect;
        }

        @Override
        public long connectTimeout() {
            return this.origin.connectTimeout();
        }

        @Override
        public long idleTimeout() {
            return this.origin.idleTimeout();
        }
    }

    public static final class WithTrustAll
    implements Settings {
        private final Settings origin;
        private final boolean trust;

        public WithTrustAll(boolean trust) {
            this(new Default(), trust);
        }

        public WithTrustAll(Settings origin, boolean trust) {
            this.origin = origin;
            this.trust = trust;
        }

        @Override
        public Optional<Proxy> proxy() {
            return this.origin.proxy();
        }

        @Override
        public boolean trustAll() {
            return this.trust;
        }

        @Override
        public boolean followRedirects() {
            return this.origin.followRedirects();
        }

        @Override
        public long connectTimeout() {
            return this.origin.connectTimeout();
        }

        @Override
        public long idleTimeout() {
            return this.origin.idleTimeout();
        }
    }

    public static final class WithProxy
    implements Settings {
        private final Settings origin;
        private final Proxy prx;

        public WithProxy(Proxy prx) {
            this(new Default(), prx);
        }

        public WithProxy(Settings origin, Proxy prx) {
            this.origin = origin;
            this.prx = prx;
        }

        @Override
        public Optional<Proxy> proxy() {
            return Optional.of(this.prx);
        }

        @Override
        public boolean trustAll() {
            return this.origin.trustAll();
        }

        @Override
        public boolean followRedirects() {
            return this.origin.followRedirects();
        }

        @Override
        public long connectTimeout() {
            return this.origin.connectTimeout();
        }

        @Override
        public long idleTimeout() {
            return this.origin.idleTimeout();
        }
    }

    public static final class Default
    implements Settings {
        @Override
        public Optional<Proxy> proxy() {
            return Optional.empty();
        }

        @Override
        public boolean trustAll() {
            return false;
        }

        @Override
        public boolean followRedirects() {
            return false;
        }

        @Override
        public long connectTimeout() {
            return 15000L;
        }

        @Override
        public long idleTimeout() {
            return 0L;
        }
    }

    public static interface Proxy {
        public boolean secure();

        public String host();

        public int port();

        public static final class Simple
        implements Proxy {
            private final boolean secure;
            private final String host;
            private final int port;

            public Simple(boolean secure, String host, int port) {
                this.secure = secure;
                this.host = host;
                this.port = port;
            }

            @Override
            public boolean secure() {
                return this.secure;
            }

            @Override
            public String host() {
                return this.host;
            }

            @Override
            public int port() {
                return this.port;
            }
        }
    }
}

