/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.client;

import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.client.ClientSlices;
import com.artipie.http.client.PathPrefixSlice;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import org.reactivestreams.Publisher;

public final class UriClientSlice
implements Slice {
    private final ClientSlices client;
    private final URI uri;

    public UriClientSlice(ClientSlices client, URI uri) {
        this.client = client;
        this.uri = uri;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        String path = this.uri.getRawPath();
        Object slice = path == null ? this.base() : new PathPrefixSlice(this.base(), path);
        return slice.response(line, headers, body);
    }

    private Slice base() {
        Slice slice;
        String scheme = this.uri.getScheme();
        String host = this.uri.getHost();
        int port = this.uri.getPort();
        switch (scheme) {
            case "https": {
                if (port > 0) {
                    slice = this.client.https(host, port);
                    break;
                }
                slice = this.client.https(host);
                break;
            }
            case "http": {
                if (port > 0) {
                    slice = this.client.http(host, port);
                    break;
                }
                slice = this.client.http(host);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Scheme '%s' is not supported", scheme));
            }
        }
        return slice;
    }
}

