/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.client.auth;

import com.artipie.http.Headers;
import com.artipie.http.headers.Authorization;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public interface Authenticator {
    public static final Authenticator ANONYMOUS = ignored -> CompletableFuture.completedFuture(Headers.EMPTY);

    public CompletionStage<Headers> authenticate(Headers var1);

    public static final class Basic
    implements Authenticator {
        private final String username;
        private final String password;

        public Basic(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public CompletionStage<Headers> authenticate(Headers headers) {
            return CompletableFuture.completedFuture(new Headers.From((Map.Entry)new Authorization.Basic(this.username, this.password)));
        }
    }
}

