/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.client.auth;

import com.artipie.asto.Content;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.http.Headers;
import com.artipie.http.client.ClientSlices;
import com.artipie.http.client.UriClientSlice;
import com.artipie.http.client.auth.Authenticator;
import com.artipie.http.client.auth.TokenFormat;
import com.artipie.http.headers.Authorization;
import com.artipie.http.headers.WwwAuthenticate;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RqMethod;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class BearerAuthenticator
implements Authenticator {
    private final ClientSlices client;
    private final TokenFormat format;

    public BearerAuthenticator(ClientSlices client, TokenFormat format) {
        this.client = client;
        this.format = format;
    }

    @Override
    public CompletionStage<Headers> authenticate(Headers headers) {
        return this.authenticate(new WwwAuthenticate(headers)).thenApply(Headers.From::new);
    }

    private CompletionStage<Authorization.Bearer> authenticate(WwwAuthenticate header) {
        URI realm;
        try {
            realm = new URI(header.realm());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        CompletableFuture promise = new CompletableFuture();
        return new UriClientSlice(this.client, realm).response(new RequestLine(RqMethod.GET, "").toString(), (Iterable<Map.Entry<String, String>>)Headers.EMPTY, (Publisher<ByteBuffer>)Content.EMPTY).send((status, headers, body) -> new PublisherAs(body).bytes().thenApply(this.format::token).thenCompose(token -> {
            promise.complete(token);
            return CompletableFuture.allOf(new CompletableFuture[0]);
        })).thenCompose(ignored -> promise).thenApply(Authorization.Bearer::new);
    }
}

