/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.client.auth;

import com.artipie.http.Headers;
import com.artipie.http.client.auth.Authenticator;
import com.artipie.http.headers.WwwAuthenticate;
import java.util.concurrent.CompletionStage;
import java.util.stream.StreamSupport;

public final class GenericAuthenticator
implements Authenticator {
    private final Authenticator.Basic basic;

    public GenericAuthenticator(String username, String password) {
        this.basic = new Authenticator.Basic(username, password);
    }

    @Override
    public CompletionStage<Headers> authenticate(Headers headers) {
        return StreamSupport.stream(headers.spliterator(), false).filter(header -> ((String)header.getKey()).equals("WWW-Authenticate")).findAny().map(header -> this.authenticate(new WwwAuthenticate((String)header.getValue()))).orElse(Authenticator.ANONYMOUS).authenticate(headers);
    }

    public Authenticator authenticate(WwwAuthenticate header) {
        String scheme = header.scheme();
        if ("Basic".equals(scheme)) {
            return this.basic;
        }
        throw new IllegalArgumentException(String.format("Unsupported scheme: %s", scheme));
    }
}

