/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.client.jetty;

import com.artipie.asto.ext.PublisherAs;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.client.jetty.ClosablePublisher;
import com.artipie.http.headers.Header;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsFull;
import com.artipie.http.rs.RsStatus;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Flowable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.reactivestreams.Publisher;

final class JettyClientSlice
implements Slice {
    private final HttpClient client;
    private final boolean secure;
    private final String host;
    private final int port;

    JettyClientSlice(HttpClient client, boolean secure, String host, int port) {
        this.client = client;
        this.secure = secure;
        this.host = host;
        this.port = port;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(this.request(line, headers, body).thenCompose(request -> (CompletionStage)Flowable.fromPublisher((Publisher)ReactiveRequest.newBuilder((Request)request).build().response((response, rsbody) -> Flowable.just(connection -> {
            ClosablePublisher closable = new ClosablePublisher((Publisher<ContentChunk>)rsbody);
            RsFull origin = new RsFull(new RsStatus.ByCode(response.getStatus()).find(), (Iterable)((Object)new ResponseHeaders((ReactiveResponse)response)), (Publisher)Flowable.fromPublisher((Publisher)closable).map(chunk -> chunk.buffer));
            return origin.send(connection).handle((nothing, throwable) -> {
                CompletableFuture<Void> original;
                if (throwable == null) {
                    original = CompletableFuture.allOf(new CompletableFuture[0]);
                } else {
                    original = new CompletableFuture();
                    original.completeExceptionally((Throwable)throwable);
                }
                return closable.close().thenCompose(nthng -> original);
            }).thenCompose(Function.identity());
        }))).singleOrError().to(SingleInterop.get())));
    }

    private CompletionStage<Request> request(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RequestLineFrom req = new RequestLineFrom(line);
        String scheme = this.secure ? "https" : "http";
        URI uri = req.uri();
        Request request = this.client.newRequest(new URIBuilder().setScheme(scheme).setHost(this.host).setPort(this.port).setPath(uri.getPath()).setCustomQuery(uri.getQuery()).toString()).method(req.method().value());
        for (Map.Entry<String, String> header : headers) {
            request.header(header.getKey(), header.getValue());
        }
        return new PublisherAs(body).bytes().thenApply(bytes -> {
            Request result = ((byte[])bytes).length > 0 ? request.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{bytes})) : request;
            return result;
        });
    }

    private static class ResponseHeaders
    extends Headers.Wrap {
        ResponseHeaders(ReactiveResponse response) {
            super((Iterable)new Headers.From((Iterable)response.getHeaders().stream().map(header -> new Header(header.getName(), header.getValue())).collect(Collectors.toList())));
        }
    }
}

