/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.client.auth;

import com.artipie.asto.Content;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.client.auth.Authenticator;
import com.artipie.http.rs.RsStatus;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class AuthClientSlice
implements Slice {
    private final Slice origin;
    private final Authenticator auth;

    public AuthClientSlice(Slice origin, Authenticator auth) {
        this.origin = origin;
        this.auth = auth;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(new PublisherAs(body).bytes().thenApply(Content.From::new).thenApply(copy -> connection -> this.auth.authenticate(Headers.EMPTY).thenCompose(first -> this.origin.response(line, (Iterable)new Headers.From(headers, (Iterable)first), (Publisher)copy).send((rsstatus, rsheaders, rsbody) -> {
            CompletionStage sent = rsstatus == RsStatus.UNAUTHORIZED ? this.auth.authenticate(rsheaders).thenCompose(second -> {
                CompletionStage result = Iterables.isEmpty((Iterable)second) ? connection.accept(rsstatus, rsheaders, rsbody) : this.origin.response(line, (Iterable)new Headers.From(headers, (Iterable)second), (Publisher)copy).send(connection);
                return result;
            }) : connection.accept(rsstatus, rsheaders, rsbody);
            return sent;
        }))));
    }
}

