/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.client.auth;

import com.artipie.asto.Content;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.http.Headers;
import com.artipie.http.client.ClientSlices;
import com.artipie.http.client.UriClientSlice;
import com.artipie.http.client.auth.AuthClientSlice;
import com.artipie.http.client.auth.Authenticator;
import com.artipie.http.client.auth.TokenFormat;
import com.artipie.http.headers.Authorization;
import com.artipie.http.headers.WwwAuthenticate;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RqMethod;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

public final class BearerAuthenticator
implements Authenticator {
    private final ClientSlices client;
    private final TokenFormat format;
    private final Authenticator auth;

    public BearerAuthenticator(ClientSlices client, TokenFormat format, Authenticator auth) {
        this.client = client;
        this.format = format;
        this.auth = auth;
    }

    @Override
    public CompletionStage<Headers> authenticate(Headers headers) {
        return this.authenticate(new WwwAuthenticate(headers)).thenApply(Headers.From::new);
    }

    private CompletionStage<Authorization.Bearer> authenticate(WwwAuthenticate header) {
        URI realm;
        try {
            realm = new URI(header.realm());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        String query = header.params().stream().filter(param -> !param.name().equals("realm")).map(param -> String.format("%s=%s", param.name(), param.value())).collect(Collectors.joining("&"));
        CompletableFuture promise = new CompletableFuture();
        return new AuthClientSlice(new UriClientSlice(this.client, realm), this.auth).response(new RequestLine(RqMethod.GET, String.format("?%s", query)).toString(), (Iterable<Map.Entry<String, String>>)Headers.EMPTY, (Publisher<ByteBuffer>)Content.EMPTY).send((status, headers, body) -> new PublisherAs(body).bytes().thenApply(this.format::token).thenCompose(token -> {
            promise.complete(token);
            return CompletableFuture.allOf(new CompletableFuture[0]);
        })).thenCompose(ignored -> promise).thenApply(Authorization.Bearer::new);
    }
}

