/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.client.auth;

import com.artipie.http.Headers;
import com.artipie.http.client.ClientSlices;
import com.artipie.http.client.auth.Authenticator;
import com.artipie.http.client.auth.BasicAuthenticator;
import com.artipie.http.client.auth.BearerAuthenticator;
import com.artipie.http.client.auth.OAuthTokenFormat;
import com.artipie.http.headers.WwwAuthenticate;
import java.util.concurrent.CompletionStage;
import java.util.stream.StreamSupport;

public final class GenericAuthenticator
implements Authenticator {
    private final Authenticator basic;
    private final Authenticator bearer;

    public GenericAuthenticator(ClientSlices client) {
        this(Authenticator.ANONYMOUS, new BearerAuthenticator(client, new OAuthTokenFormat(), Authenticator.ANONYMOUS));
    }

    public GenericAuthenticator(ClientSlices client, String username, String password) {
        this(new BasicAuthenticator(username, password), new BearerAuthenticator(client, new OAuthTokenFormat(), new BasicAuthenticator(username, password)));
    }

    public GenericAuthenticator(Authenticator basic, Authenticator bearer) {
        this.basic = basic;
        this.bearer = bearer;
    }

    @Override
    public CompletionStage<Headers> authenticate(Headers headers) {
        return StreamSupport.stream(headers.spliterator(), false).filter(header -> ((String)header.getKey()).equals("WWW-Authenticate")).findAny().map(header -> this.authenticate(new WwwAuthenticate((String)header.getValue()))).orElse(Authenticator.ANONYMOUS).authenticate(headers);
    }

    public Authenticator authenticate(WwwAuthenticate header) {
        Authenticator result;
        String scheme = header.scheme();
        if ("Basic".equals(scheme)) {
            result = this.basic;
        } else if ("Bearer".equals(scheme)) {
            result = this.bearer;
        } else {
            throw new IllegalArgumentException(String.format("Unsupported scheme: %s", scheme));
        }
        return result;
    }
}

