/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.auth.Identities;
import com.artipie.http.auth.Permission;
import com.artipie.http.headers.WwwAuthenticate;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import org.reactivestreams.Publisher;

public final class SliceAuth
implements Slice {
    private final Slice origin;
    private final Permission perm;
    private final Identities ids;

    public SliceAuth(Slice origin, Permission perm, Identities ids) {
        this.origin = origin;
        this.ids = ids;
        this.perm = perm;
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return this.ids.user(line, headers).map(this.perm::allowed).map(allowed -> {
            Response rsp = allowed != false ? this.origin.response(line, headers, body) : new RsWithStatus(RsStatus.FORBIDDEN);
            return rsp;
        }).orElseGet(() -> {
            Response rsp = this.perm.allowed("*") ? this.origin.response(line, headers, body) : new RsWithHeaders((Response)new RsWithStatus(RsStatus.UNAUTHORIZED), new Headers.From((Map.Entry<String, String>)new WwwAuthenticate("Basic")));
            return rsp;
        });
    }
}

