/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.group;

import com.artipie.http.Connection;
import com.artipie.http.group.GroupResult;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;

final class GroupResults {
    private final List<GroupResult> list;
    private final AtomicBoolean done;

    GroupResults(int cap) {
        this(new ArrayList<Object>(Collections.nCopies(cap, null)));
    }

    private GroupResults(List<GroupResult> list) {
        this.list = list;
        this.done = new AtomicBoolean();
    }

    public CompletionStage<Void> complete(int order, GroupResult result, Connection con) {
        if (order >= this.list.size()) {
            throw new IllegalStateException("Wrong order of result");
        }
        if (this.done.get()) {
            result.cancel();
            return CompletableFuture.completedFuture(null);
        }
        this.list.set(order, result);
        for (int pos = 0; pos < this.list.size(); ++pos) {
            GroupResult target = this.list.get(pos);
            if (target == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (!target.success()) continue;
            this.done.set(true);
            this.list.remove(target);
            this.list.forEach(GroupResult::cancel);
            return target.replay(con);
        }
        this.done.set(true);
        return new RsWithStatus(RsStatus.NOT_FOUND).send(con);
    }
}

