/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.hm;

import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.rs.RsStatus;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;
import org.reactivestreams.Publisher;

public final class RsHasBody
extends TypeSafeMatcher<Response> {
    private final Matcher<byte[]> body;

    public RsHasBody(byte[] body) {
        this((Matcher<byte[]>)new IsEqual((Object)body));
    }

    public RsHasBody(Matcher<byte[]> body) {
        this.body = body;
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.body);
    }

    public boolean matchesSafely(Response item) {
        AtomicReference<byte[]> out = new AtomicReference<byte[]>();
        item.send(new FakeConnection(out)).toCompletableFuture().join();
        return this.body.matches((Object)out.get());
    }

    private static final class FakeConnection
    implements Connection {
        private final AtomicReference<byte[]> container;

        FakeConnection(AtomicReference<byte[]> container) {
            this.container = container;
        }

        @Override
        public CompletionStage<Void> accept(RsStatus status, Headers headers, Publisher<ByteBuffer> body) {
            return CompletableFuture.supplyAsync(() -> {
                ByteBuffer buffer = ((List)Flowable.fromPublisher((Publisher)body).toList().blockingGet()).stream().reduce((left, right) -> {
                    left.mark();
                    right.mark();
                    ByteBuffer concat = ByteBuffer.allocate(left.remaining() + right.remaining()).put((ByteBuffer)left).put((ByteBuffer)right);
                    left.reset();
                    right.reset();
                    concat.flip();
                    return concat;
                }).orElse(ByteBuffer.allocate(0));
                byte[] bytes = new byte[buffer.remaining()];
                buffer.mark();
                buffer.get(bytes);
                buffer.reset();
                this.container.set(bytes);
                return null;
            });
        }
    }
}

