/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.slice;

import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.headers.Header;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithStatus;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.utils.URIBuilder;
import org.reactivestreams.Publisher;

public final class TrimPathSlice
implements Slice {
    private final Slice slice;
    private final Pattern ptn;

    public TrimPathSlice(Slice slice, String path) {
        this(slice, Pattern.compile(String.format("^/(?:%s)(\\/.*)?", TrimPathSlice.normalized(path))));
    }

    public TrimPathSlice(Slice slice, Pattern ptn) {
        this.slice = slice;
        this.ptn = ptn;
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RequestLineFrom rline = new RequestLineFrom(line);
        URI uri = rline.uri();
        String full = uri.getPath();
        Matcher matcher = this.ptn.matcher(full);
        Response response = matcher.matches() ? this.slice.response(new RequestLine(rline.method().toString(), new URIBuilder(uri).setPath(TrimPathSlice.asPath(matcher.group(1))).toString(), rline.version()).toString(), Iterables.concat(headers, Collections.singletonList(new Header("X-FullPath", full))), body) : new RsWithStatus(new RsWithBody(String.format("Request path %s was not matched to %s", full, this.ptn), StandardCharsets.UTF_8), RsStatus.INTERNAL_ERROR);
        return response;
    }

    private static String normalized(String path) {
        String clear = Objects.requireNonNull(path).trim();
        if (clear.isEmpty()) {
            return "";
        }
        if (clear.charAt(0) == '/') {
            return TrimPathSlice.normalized(clear.substring(1));
        }
        if (clear.charAt(clear.length() - 1) == '/') {
            return TrimPathSlice.normalized(clear.substring(0, clear.length() - 1));
        }
        return clear;
    }

    private static String asPath(String result) {
        if (result == null || result.isEmpty()) {
            return "/";
        }
        if (result.charAt(0) != '/') {
            return '/' + result;
        }
        return result;
    }
}

