/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.group;

import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.rs.RsStatus;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class GroupResult {
    private static final Subscriber<? super Object> CANCEL_SUB = new Subscriber<Object>(){

        public void onSubscribe(Subscription sub) {
            sub.cancel();
        }

        public void onNext(Object obj) {
        }

        public void onError(Throwable err) {
        }

        public void onComplete() {
        }
    };
    private final RsStatus status;
    private final Headers headers;
    private final Publisher<ByteBuffer> body;

    GroupResult(RsStatus status, Headers headers, Publisher<ByteBuffer> body) {
        this.status = status;
        this.headers = headers;
        this.body = body;
    }

    public CompletionStage<Void> replay(Connection con) {
        return con.accept(this.status, this.headers, this.body);
    }

    public boolean success() {
        int code = Integer.parseInt(this.status.code());
        return code >= 200 && code < 300;
    }

    void cancel() {
        this.body.subscribe(CANCEL_SUB);
    }
}

