/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.headers;

import com.artipie.http.Headers;
import com.artipie.http.headers.Header;
import com.artipie.http.rq.RqHeaders;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class WwwAuthenticate
extends Header.Wrap {
    public static final String NAME = "WWW-Authenticate";
    private static final Pattern VALUE = Pattern.compile("(?<scheme>[^\"]*)( (?<params>.*))?");

    public WwwAuthenticate(String value) {
        super(new Header(NAME, value));
    }

    public WwwAuthenticate(Headers headers) {
        this(new RqHeaders.Single(headers, NAME).asString());
    }

    public String scheme() {
        return this.matcher().group("scheme");
    }

    public List<Param> params() {
        return Optional.ofNullable(this.matcher().group("params")).map(params -> Stream.of(params.split(",")).map(Param::new).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    public String realm() {
        return this.params().stream().filter(param -> "realm".equals(param.name())).map(Param::value).findAny().orElseThrow(() -> new IllegalStateException(String.format("No realm param found: %s", this.getValue())));
    }

    private Matcher matcher() {
        String value = this.getValue();
        Matcher matcher = VALUE.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Failed to parse header value: %s", value));
        }
        return matcher;
    }

    public static class Param {
        private static final Pattern PATTERN = Pattern.compile("(?<name>[^=]*)=\"(?<value>[^\"]*)\"");
        private final String string;

        public Param(String string) {
            this.string = string;
        }

        public String name() {
            return this.matcher().group("name");
        }

        public String value() {
            return this.matcher().group("value");
        }

        private Matcher matcher() {
            String value = this.string;
            Matcher matcher = PATTERN.matcher(value);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("Failed to parse param: %s", value));
            }
            return matcher;
        }
    }
}

