/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import java.util.Optional;

public interface Authentication {
    public Optional<String> user(String var1, String var2);

    public static final class Single
    implements Authentication {
        private final String username;
        private final String password;

        public Single(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public Optional<String> user(String user, String pass) {
            return Optional.of(user).filter(this.username::equals).filter(ignored -> this.password.equals(pass));
        }
    }

    public static abstract class Wrap
    implements Authentication {
        private final Authentication auth;

        protected Wrap(Authentication auth) {
            this.auth = auth;
        }

        @Override
        public final Optional<String> user(String username, String password) {
            return this.auth.user(username, password);
        }
    }
}

