/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.hm;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Remaining;
import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rs.RsStatus;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.cactoos.Func;
import org.cactoos.func.StickyFunc;
import org.cactoos.func.UncheckedFunc;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.reactivestreams.Publisher;

public final class SliceHasResponse
extends TypeSafeMatcher<Slice> {
    private final Matcher<? extends Response> rsp;
    private final UncheckedFunc<Slice, Response> target;

    public SliceHasResponse(Matcher<? extends Response> rsp, RequestLine line) {
        this(rsp, line, Headers.EMPTY, (Content)new Content.From((Publisher)Flowable.empty()));
    }

    public SliceHasResponse(Matcher<? extends Response> rsp, RequestLine line, Headers headers, Content body) {
        this.rsp = rsp;
        this.target = new UncheckedFunc((Func)new StickyFunc(slice -> new StatefulResponse(slice.response(line.toString(), headers, (Publisher<ByteBuffer>)body))));
    }

    public boolean matchesSafely(Slice item) {
        return this.rsp.matches(this.target.apply((Object)item));
    }

    public void describeTo(Description description) {
        description.appendText("response: ").appendDescriptionOf(this.rsp);
    }

    public void describeMismatchSafely(Slice item, Description description) {
        description.appendText("response was: ").appendValue(this.target.apply((Object)item));
    }

    private static final class StatefulConnection
    implements Connection {
        private volatile RsStatus status;
        private volatile Headers headers;
        private volatile Publisher<ByteBuffer> body;

        private StatefulConnection() {
        }

        @Override
        public CompletionStage<Void> accept(RsStatus stts, Headers hdrs, Publisher<ByteBuffer> bdy) {
            this.status = stts;
            this.headers = hdrs;
            this.body = Flowable.fromPublisher(bdy).cache();
            return CompletableFuture.completedFuture(null);
        }

        public String toString() {
            return String.format("(%s: status=%s, headers=[%s], body=%s)", new Object[]{this.getClass().getSimpleName(), this.status, StreamSupport.stream(this.headers.spliterator(), false).map(header -> String.format("\"%s\": \"%s\"", header.getKey(), header.getValue())).collect(Collectors.joining(", ")), Arrays.toString((byte[])new Concatenation(this.body).single().map(buf -> new Remaining(buf).bytes()).blockingGet())});
        }

        CompletionStage<StatefulConnection> load(Response response) {
            CompletionStage<StatefulConnection> self = this.status == null && this.headers == null && this.body == null ? response.send(this).thenApply(none -> this) : CompletableFuture.completedFuture(this);
            return self;
        }

        CompletionStage<Void> replay(Connection connection) {
            return connection.accept(this.status, this.headers, this.body);
        }
    }

    private static final class StatefulResponse
    implements Response {
        private final Response origin;
        private final StatefulConnection con;

        StatefulResponse(Response origin) {
            this.origin = origin;
            this.con = new StatefulConnection();
        }

        @Override
        public CompletionStage<Void> send(Connection connection) {
            return this.con.load(this.origin).thenCompose(self -> self.replay(connection));
        }

        public String toString() {
            return String.format("(%s: state=%s)", this.getClass().getSimpleName(), this.con.toString());
        }
    }
}

