/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.hm;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Remaining;
import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.rs.RsStatus;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;

public final class StatefulResponse
implements Response {
    private final Response origin;
    private final StatefulConnection con;

    public StatefulResponse(Response origin) {
        this.origin = origin;
        this.con = new StatefulConnection();
    }

    @Override
    public CompletionStage<Void> send(Connection connection) {
        return this.con.load(this.origin).thenCompose(self -> self.replay(connection));
    }

    public String toString() {
        return String.format("(%s: state=%s)", this.getClass().getSimpleName(), this.con.toString());
    }

    private static final class StatefulConnection
    implements Connection {
        private volatile RsStatus status;
        private volatile Headers headers;
        private volatile Publisher<ByteBuffer> body;

        private StatefulConnection() {
        }

        @Override
        public CompletionStage<Void> accept(RsStatus stts, Headers hdrs, Publisher<ByteBuffer> bdy) {
            this.status = stts;
            this.headers = hdrs;
            this.body = Flowable.fromPublisher(bdy).cache();
            return CompletableFuture.completedFuture(null);
        }

        public String toString() {
            return String.format("(%s: status=%s, headers=[%s], body=%s)", new Object[]{this.getClass().getSimpleName(), this.status, StreamSupport.stream(this.headers.spliterator(), false).map(header -> String.format("\"%s\": \"%s\"", header.getKey(), header.getValue())).collect(Collectors.joining(", ")), Arrays.toString((byte[])new Concatenation(this.body).single().map(buf -> new Remaining(buf).bytes()).blockingGet())});
        }

        CompletionStage<StatefulConnection> load(Response response) {
            CompletionStage<StatefulConnection> self = this.status == null && this.headers == null && this.body == null ? response.send(this).thenApply(none -> this) : CompletableFuture.completedFuture(this);
            return self;
        }

        CompletionStage<Void> replay(Connection connection) {
            return connection.accept(this.status, this.headers, this.body);
        }
    }
}

