/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rs.common;

import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.headers.ContentLength;
import com.artipie.http.headers.ContentType;
import com.artipie.http.rs.RsStatus;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import org.reactivestreams.Publisher;

public final class RsJson
implements Response {
    private final Supplier<? extends JsonStructure> json;
    private final Charset encoding;

    public RsJson(JsonStructure json) {
        this(() -> json);
    }

    public RsJson(JsonObjectBuilder builder) {
        this(() -> ((JsonObjectBuilder)builder).build());
    }

    public RsJson(JsonArrayBuilder builder) {
        this(() -> ((JsonArrayBuilder)builder).build());
    }

    public RsJson(Supplier<? extends JsonStructure> json) {
        this(json, StandardCharsets.UTF_8);
    }

    public RsJson(Supplier<? extends JsonStructure> json, Charset encoding) {
        this.json = json;
        this.encoding = encoding;
    }

    @Override
    public CompletionStage<Void> send(Connection connection) {
        byte[] bytes = this.json.get().toString().getBytes(this.encoding);
        return connection.accept(RsStatus.OK, new Headers.From(new ContentType(String.format("application/json; charset=%s", this.encoding.displayName())), new ContentLength(bytes.length)), (Publisher<ByteBuffer>)Flowable.just((Object)ByteBuffer.wrap(bytes)));
    }
}

