/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.slice;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.slice.KeyFromPath;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public final class SliceDownload
implements Slice {
    private final Storage storage;
    private final Function<String, Key> transform;

    public SliceDownload(Storage storage) {
        this(storage, KeyFromPath::new);
    }

    public SliceDownload(Storage storage, Function<String, Key> transform) {
        this.storage = storage;
        this.transform = transform;
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(((CompletableFuture)CompletableFuture.supplyAsync(() -> new RequestLineFrom(line).uri().getPath()).thenApply(this.transform)).thenCompose(key -> this.storage.exists(key).thenCompose(exist -> {
            if (exist.booleanValue()) {
                return ((CompletableFuture)this.storage.value(key).thenApply(RsWithBody::new)).thenApply(rsp -> new RsWithStatus((Response)rsp, RsStatus.OK));
            }
            return CompletableFuture.completedFuture(new RsWithStatus(new RsWithBody(String.format("Key %s not found", key.string()), StandardCharsets.UTF_8), RsStatus.NOT_FOUND));
        })));
    }
}

