/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.group;

import com.artipie.http.Connection;
import com.artipie.http.Response;
import com.artipie.http.group.GroupConnection;
import com.artipie.http.group.GroupResults;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

final class GroupResponse
implements Response {
    private final List<Response> responses;

    GroupResponse(List<Response> responses) {
        this.responses = responses;
    }

    @Override
    public CompletionStage<Void> send(Connection con) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        GroupResults results = new GroupResults(this.responses.size(), future);
        for (int pos = 0; pos < this.responses.size(); ++pos) {
            this.responses.get(pos).send(new GroupConnection(con, pos, results));
        }
        return future;
    }

    public String toString() {
        return String.format("%s: [%s]", this.getClass().getSimpleName(), this.responses.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }
}

