/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rs;

import java.util.stream.Stream;
import javax.annotation.Nullable;

public enum RsStatus {
    CONTINUE("100"),
    OK("200"),
    CREATED("201"),
    ACCEPTED("202"),
    NO_CONTENT("204"),
    MOVED_PERMANENTLY("301"),
    FOUND("302"),
    NOT_MODIFIED("304"),
    TEMPORARY_REDIRECT("307"),
    BAD_REQUEST("400"),
    UNAUTHORIZED("401"),
    FORBIDDEN("403"),
    NOT_FOUND("404"),
    METHOD_NOT_ALLOWED("405"),
    REQUEST_TIMEOUT("408"),
    CONFLICT("409"),
    LENGTH_REQUIRED("411"),
    PAYLOAD_TOO_LARGE("413"),
    BAD_RANGE("416"),
    EXPECTATION_FAILED("417"),
    INTERNAL_ERROR("500"),
    NOT_IMPLEMENTED("501"),
    UNAVAILABLE("503");

    private final String string;

    private RsStatus(String string2) {
        this.string = string2;
    }

    public String code() {
        return this.string;
    }

    public boolean information() {
        return this.firstSymbol('1');
    }

    public boolean success() {
        return this.firstSymbol('2');
    }

    public boolean redirection() {
        return this.firstSymbol('3');
    }

    public boolean clientError() {
        return this.firstSymbol('4');
    }

    public boolean serverError() {
        return this.firstSymbol('5');
    }

    public boolean error() {
        return this.clientError() || this.serverError();
    }

    private boolean firstSymbol(char symbol) {
        return this.string.charAt(0) == symbol;
    }

    public static class ByCode {
        private final String code;

        public ByCode(@Nullable String code) {
            this.code = code;
        }

        public ByCode(int code) {
            this(String.valueOf(code));
        }

        public RsStatus find() {
            return Stream.of(RsStatus.values()).filter(status -> status.code().equals(this.code)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown status code: `%s`", this.code)));
        }
    }
}

