/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rt;

import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rt.RtRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ByMethodsRule
implements RtRule {
    private final Set<RqMethod> methods;

    public ByMethodsRule(RqMethod ... methods) {
        this(new HashSet<RqMethod>(Arrays.asList(methods)));
    }

    public ByMethodsRule(Set<RqMethod> methods) {
        this.methods = Collections.unmodifiableSet(methods);
    }

    @Override
    public boolean apply(String line, Iterable<Map.Entry<String, String>> headers) {
        return this.methods.contains((Object)new RequestLineFrom(line).method());
    }

    public static enum Standard implements RtRule
    {
        GET(new ByMethodsRule(RqMethod.GET)),
        POST(new ByMethodsRule(RqMethod.POST)),
        PUT(new ByMethodsRule(RqMethod.PUT)),
        DELETE(new ByMethodsRule(RqMethod.DELETE)),
        ALL_READ(new ByMethodsRule(RqMethod.GET, RqMethod.HEAD, RqMethod.OPTIONS)),
        ALL_WRITE(new ByMethodsRule(RqMethod.PUT, RqMethod.POST, RqMethod.DELETE, RqMethod.PATCH));

        private final RtRule origin;

        private Standard(RtRule origin) {
            this.origin = origin;
        }

        @Override
        public boolean apply(String line, Iterable<Map.Entry<String, String>> headers) {
            return this.origin.apply(line, headers);
        }
    }
}

