/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.auth.Authentication;
import com.artipie.http.auth.Permission;
import com.artipie.http.auth.Permissions;
import com.artipie.http.headers.WwwAuthenticate;
import com.artipie.http.rq.RqHeaders;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import org.cactoos.text.Base64Decoded;
import org.reactivestreams.Publisher;

public final class BasicAuthSlice
implements Slice {
    public static final String SCHEME = "Basic";
    private final Slice origin;
    private final Authentication auth;
    private final Permission perm;

    public BasicAuthSlice(Slice origin, Authentication auth, Permission perm) {
        this.origin = origin;
        this.auth = auth;
        this.perm = perm;
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return this.user(headers).map(this.perm::allowed).map(allowed -> {
            Response rsp = allowed != false ? this.origin.response(line, headers, body) : new RsWithStatus(RsStatus.FORBIDDEN);
            return rsp;
        }).orElseGet(() -> {
            Response rsp = this.perm.allowed(Permissions.ANY_USER) ? this.origin.response(line, headers, body) : new RsWithHeaders((Response)new RsWithStatus(RsStatus.UNAUTHORIZED), new Headers.From((Map.Entry<String, String>)new WwwAuthenticate(SCHEME)));
            return rsp;
        });
    }

    private Optional<Authentication.User> user(Iterable<Map.Entry<String, String>> headers) {
        return new RqHeaders(headers, "Authorization").stream().findFirst().filter(hdr -> hdr.startsWith(SCHEME)).map(hdr -> new Base64Decoded(hdr.substring(SCHEME.length() + 1))).map(dec -> dec.toString().split(":")).flatMap(cred -> this.auth.user(cred[0].trim(), cred[1].trim()));
    }
}

