/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import com.artipie.http.auth.Action;
import com.artipie.http.auth.Authentication;
import com.artipie.http.auth.Permissions;
import java.util.Arrays;
import java.util.stream.StreamSupport;

public interface Permission {
    public boolean allowed(Authentication.User var1);

    public static final class All
    implements Permission {
        private final Iterable<Permission> origin;

        public All(Permission ... origin) {
            this(Arrays.asList(origin));
        }

        public All(Iterable<Permission> origin) {
            this.origin = origin;
        }

        @Override
        public boolean allowed(Authentication.User user) {
            return StreamSupport.stream(this.origin.spliterator(), false).allMatch(perm -> perm.allowed(user));
        }
    }

    public static final class ByName
    implements Permission {
        private final Permissions perm;
        private final Action action;

        public ByName(Permissions perm, Action action) {
            this.perm = perm;
            this.action = action;
        }

        public ByName(String action, Permissions perm) {
            this(perm, new Action.ByString(action).get());
        }

        @Override
        public boolean allowed(Authentication.User user) {
            boolean res = false;
            for (String synonym : this.action.names()) {
                if (!this.perm.allowed(user, synonym)) continue;
                res = true;
                break;
            }
            return res;
        }
    }
}

