/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rt;

import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqHeaders;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rt.ByMethodsRule;
import java.util.Map;
import java.util.regex.Pattern;
import org.cactoos.list.ListOf;

public interface RtRule {
    public static final RtRule FALLBACK = (line, headers) -> true;

    public boolean apply(String var1, Iterable<Map.Entry<String, String>> var2);

    public static final class ByHeader
    implements RtRule {
        private final String name;
        private final Pattern ptn;

        public ByHeader(String name, Pattern ptn) {
            this.name = name;
            this.ptn = ptn;
        }

        public ByHeader(String name) {
            this(name, Pattern.compile(".*"));
        }

        @Override
        public boolean apply(String line, Iterable<Map.Entry<String, String>> headers) {
            return new RqHeaders(headers, this.name).stream().anyMatch(val -> this.ptn.matcher((CharSequence)val).matches());
        }
    }

    public static abstract class Wrap
    implements RtRule {
        private final RtRule origin;

        protected Wrap(RtRule origin) {
            this.origin = origin;
        }

        @Override
        public final boolean apply(String line, Iterable<Map.Entry<String, String>> headers) {
            return this.origin.apply(line, headers);
        }
    }

    public static final class ByPath
    implements RtRule {
        private final Pattern ptn;

        public ByPath(String ptn) {
            this(Pattern.compile(ptn));
        }

        public ByPath(Pattern ptn) {
            this.ptn = ptn;
        }

        @Override
        public boolean apply(String line, Iterable<Map.Entry<String, String>> headers) {
            return this.ptn.matcher(new RequestLineFrom(line).uri().getPath()).matches();
        }
    }

    @Deprecated
    public static final class ByMethod
    extends Wrap {
        public ByMethod(RqMethod method) {
            super(new ByMethodsRule(method));
        }
    }

    public static final class Any
    implements RtRule {
        private final Iterable<RtRule> rules;

        public Any(RtRule ... rules) {
            this((Iterable<RtRule>)new ListOf((Object[])rules));
        }

        public Any(Iterable<RtRule> rules) {
            this.rules = rules;
        }

        @Override
        public boolean apply(String line, Iterable<Map.Entry<String, String>> headers) {
            boolean match = false;
            for (RtRule rule : this.rules) {
                if (!rule.apply(line, headers)) continue;
                match = true;
                break;
            }
            return match;
        }
    }

    public static class All
    implements RtRule {
        private final Iterable<RtRule> rules;

        public All(RtRule ... rules) {
            this((Iterable<RtRule>)new ListOf((Object[])rules));
        }

        public All(Iterable<RtRule> rules) {
            this.rules = rules;
        }

        @Override
        public boolean apply(String line, Iterable<Map.Entry<String, String>> headers) {
            boolean match = true;
            for (RtRule rule : this.rules) {
                if (rule.apply(line, headers)) continue;
                match = false;
                break;
            }
            return match;
        }
    }

    @Deprecated
    public static final class Multiple
    extends All {
        public Multiple(RtRule ... rules) {
            super((Iterable<RtRule>)new ListOf((Object[])rules));
        }

        public Multiple(Iterable<RtRule> rules) {
            super(rules);
        }
    }
}

