/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rq;

import com.artipie.http.rq.Part;
import com.artipie.http.rq.PartFromPublisher;
import com.artipie.http.stream.ByteByByteSplit;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class Multipart
implements Processor<ByteBuffer, Part> {
    private static final String CRLF = "\r\n";
    private final Subscriber<ByteBuffer> subscriber;
    private final Publisher<Part> publisher;

    public Multipart(Iterable<Map.Entry<String, String>> headers) {
        this(() -> Multipart.boundary(headers));
    }

    public Multipart(Supplier<String> boundary) {
        this(boundary.get());
    }

    public Multipart(String boundary) {
        this(new ByteByByteSplit(boundary.getBytes(StandardCharsets.UTF_8)));
    }

    public Multipart(Processor<ByteBuffer, Publisher<ByteBuffer>> processor) {
        this.subscriber = processor;
        this.publisher = Flowable.fromPublisher(processor).map(PartFromPublisher::new);
    }

    public void subscribe(Subscriber<? super Part> sub) {
        this.publisher.subscribe(sub);
    }

    public void onSubscribe(Subscription subscription) {
        this.subscriber.onSubscribe(subscription);
    }

    public void onNext(ByteBuffer item) {
        this.subscriber.onNext((Object)item);
    }

    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    public void onComplete() {
        this.subscriber.onComplete();
    }

    private static String boundary(Iterable<Map.Entry<String, String>> headers) {
        Pattern pattern = Pattern.compile("boundary=(\\w+)");
        String type = StreamSupport.stream(headers.spliterator(), false).filter(header -> ((String)header.getKey()).equalsIgnoreCase("content-type")).map(Map.Entry::getValue).findFirst().get();
        Matcher matcher = pattern.matcher(type);
        matcher.find();
        return matcher.group(1);
    }
}

