/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rt;

import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rt.RtRule;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.cactoos.list.ListOf;
import org.reactivestreams.Publisher;

public final class SliceRoute
implements Slice {
    private final List<Path> routes;

    public SliceRoute(Path ... routes) {
        this((List<Path>)new ListOf((Object[])routes));
    }

    public SliceRoute(List<Path> routes) {
        this.routes = routes;
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return this.routes.stream().map(item -> item.response(line, headers, body)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(new RsWithBody(new RsWithStatus(RsStatus.NOT_FOUND), "not found", StandardCharsets.UTF_8));
    }

    public static final class Path {
        private final RtRule rule;
        private final Slice slice;

        public Path(RtRule rule, Slice slice) {
            this.rule = rule;
            this.slice = slice;
        }

        Optional<Response> response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Optional<Response> res = this.rule.apply(line, headers) ? Optional.of(this.slice.response(line, headers, body)) : Optional.empty();
            return res;
        }
    }
}

