/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import com.artipie.http.auth.Authentication;
import com.artipie.http.auth.Identities;
import com.artipie.http.rq.RqHeaders;
import java.util.Map;
import java.util.Optional;
import org.cactoos.text.Base64Decoded;

public final class BasicIdentities
implements Identities {
    private final Authentication auth;

    BasicIdentities(Authentication auth) {
        this.auth = auth;
    }

    @Override
    public Optional<String> user(String line, Iterable<Map.Entry<String, String>> headers) {
        String cred;
        String prefix = "Basic ";
        Optional<String> result = Optional.empty();
        RqHeaders hdrs = new RqHeaders(headers, "Authorization");
        if (!hdrs.isEmpty() && (cred = (String)hdrs.get(0)).startsWith("Basic ")) {
            String[] credentials = new Base64Decoded(cred.substring("Basic ".length())).toString().split(":");
            String username = credentials[0].trim();
            String password = credentials[1].trim();
            this.auth.verify(username, password);
            result = Optional.of(username);
        }
        return result;
    }
}

