/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.hm;

import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.rs.Header;
import com.artipie.http.rs.RsStatus;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;
import org.reactivestreams.Publisher;

public final class RsHasHeaders
extends TypeSafeMatcher<Response> {
    private final Matcher<Iterable<? extends Map.Entry<String, String>>> headers;

    @SafeVarargs
    public RsHasHeaders(Map.Entry<String, String> ... headers) {
        this(Arrays.asList(headers));
    }

    public RsHasHeaders(Collection<? extends Map.Entry<String, String>> headers) {
        this((Matcher<Iterable<? extends Map.Entry<String, String>>>)Matchers.containsInAnyOrder((Collection)headers.stream().map(original -> new Header((String)original.getKey(), (String)original.getValue())).map(IsEqual::new).collect(Collectors.toList())));
    }

    @SafeVarargs
    public RsHasHeaders(Matcher<? super Map.Entry<String, String>> ... headers) {
        this((Matcher<Iterable<? extends Map.Entry<String, String>>>)Matchers.containsInAnyOrder(Arrays.asList(headers)));
    }

    public RsHasHeaders(Matcher<Iterable<? extends Map.Entry<String, String>>> headers) {
        this.headers = headers;
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.headers);
    }

    public boolean matchesSafely(Response item) {
        AtomicReference<Iterable<Map.Entry<String, String>>> out = new AtomicReference<Iterable<Map.Entry<String, String>>>();
        item.send(new FakeConnection(out)).toCompletableFuture().join();
        return this.headers.matches(out.get());
    }

    private static final class FakeConnection
    implements Connection {
        private final AtomicReference<Iterable<Map.Entry<String, String>>> container;

        FakeConnection(AtomicReference<Iterable<Map.Entry<String, String>>> container) {
            this.container = container;
        }

        public CompletableFuture<Void> accept(RsStatus status, Headers headers, Publisher<ByteBuffer> body) {
            return CompletableFuture.supplyAsync(() -> {
                this.container.set(ImmutableList.copyOf((Iterable)headers).stream().map(original -> new Header((String)original.getKey(), (String)original.getValue())).collect(Collectors.toList()));
                return null;
            });
        }
    }
}

