/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rs;

import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.StandardRs;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class RsWithBody
implements Response {
    private final Response origin;
    private final Publisher<ByteBuffer> body;

    public RsWithBody(Response origin, String body, Charset charset) {
        this(origin, ByteBuffer.wrap(body.getBytes(charset)));
    }

    public RsWithBody(String body, Charset charset) {
        this(ByteBuffer.wrap(body.getBytes(charset)));
    }

    public RsWithBody(ByteBuffer buf) {
        this((Response)StandardRs.EMPTY, buf);
    }

    public RsWithBody(Response origin, ByteBuffer buf) {
        this(origin, (Publisher<ByteBuffer>)Flowable.just((Object)buf));
    }

    public RsWithBody(Publisher<ByteBuffer> body) {
        this((Response)StandardRs.EMPTY, body);
    }

    public RsWithBody(Response origin, Publisher<ByteBuffer> body) {
        this.origin = origin;
        this.body = body;
    }

    @Override
    public CompletionStage<Void> send(Connection con) {
        return this.origin.send(new ConWithBody(con, this.body));
    }

    private static final class ConWithBody
    implements Connection {
        private final Connection origin;
        private final Publisher<ByteBuffer> body;

        ConWithBody(Connection origin, Publisher<ByteBuffer> body) {
            this.origin = origin;
            this.body = body;
        }

        @Override
        public CompletionStage<Void> accept(RsStatus status, Headers headers, Publisher<ByteBuffer> none) {
            return this.origin.accept(status, headers, this.body);
        }
    }
}

