/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rt;

import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqMethod;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.cactoos.list.ListOf;

public interface RtRule {
    public static final RtRule FALLBACK = (line, headers) -> true;

    public boolean apply(String var1, Iterable<Map.Entry<String, String>> var2);

    public static final class ByPath
    implements RtRule {
        private final Pattern ptn;

        public ByPath(String ptn) {
            this(Pattern.compile(ptn));
        }

        public ByPath(Pattern ptn) {
            this.ptn = ptn;
        }

        @Override
        public boolean apply(String line, Iterable<Map.Entry<String, String>> headers) {
            return this.ptn.matcher(new RequestLineFrom(line).uri().getPath()).matches();
        }
    }

    public static final class ByMethod
    implements RtRule {
        private final RqMethod method;

        public ByMethod(RqMethod method) {
            this.method = method;
        }

        @Override
        public boolean apply(String line, Iterable<Map.Entry<String, String>> headers) {
            return Objects.equals((Object)new RequestLineFrom(line).method(), (Object)this.method);
        }
    }

    public static final class Multiple
    implements RtRule {
        private final Iterable<RtRule> rules;

        public Multiple(RtRule ... rules) {
            this((Iterable<RtRule>)new ListOf((Object[])rules));
        }

        public Multiple(Iterable<RtRule> rules) {
            this.rules = rules;
        }

        @Override
        public boolean apply(String line, Iterable<Map.Entry<String, String>> headers) {
            boolean match = true;
            for (RtRule rule : this.rules) {
                if (rule.apply(line, headers)) continue;
                match = false;
                break;
            }
            return match;
        }
    }
}

