/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rs;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class Header
implements Map.Entry<String, String> {
    private final String name;
    private final String value;

    public Header(Map.Entry<String, String> entry) {
        this(entry.getKey(), entry.getValue());
    }

    public Header(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value.replaceAll("^\\s+", "");
    }

    @Override
    public String setValue(String ignored) {
        throw new UnsupportedOperationException("Value cannot be modified");
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Header header = (Header)that;
        return this.lowercaseName().equals(header.lowercaseName()) && this.getValue().equals(header.getValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lowercaseName(), this.getValue());
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.getValue());
    }

    private String lowercaseName() {
        return this.name.toLowerCase(Locale.US);
    }

    public static abstract class Wrap
    implements Map.Entry<String, String> {
        private final Map.Entry<String, String> header;

        protected Wrap(Map.Entry<String, String> header) {
            this.header = header;
        }

        @Override
        public final String getKey() {
            return this.header.getKey();
        }

        @Override
        public final String getValue() {
            return this.header.getValue();
        }

        @Override
        public final String setValue(String value) {
            return this.header.setValue(value);
        }

        @Override
        public final boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            Wrap wrap = (Wrap)that;
            return Objects.equals(this.header, wrap.header);
        }

        @Override
        public final int hashCode() {
            return Objects.hash(this.header);
        }

        public final String toString() {
            return this.header.toString();
        }
    }
}

