/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.slice;

import com.artipie.http.Connection;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rs.RsStatus;
import com.jcabi.log.Logger;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import org.reactivestreams.Publisher;

public final class LoggingSlice
implements Slice {
    private final Level level;
    private final Slice slice;

    public LoggingSlice(Slice slice) {
        this(Level.FINE, slice);
    }

    public LoggingSlice(Level level, Slice slice) {
        this.level = level;
        this.slice = slice;
    }

    @Override
    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        StringBuilder msg = new StringBuilder(">> ").append(line);
        LoggingSlice.append(msg, headers);
        Logger.log((Level)this.level, (Object)this.slice, (String)msg.toString(), (Object[])new Object[0]);
        return connection -> this.slice.response(line, headers, body).send(new LoggingConnection(connection));
    }

    private static void append(StringBuilder builder, Iterable<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> header : headers) {
            builder.append('\n').append(header.getKey()).append(": ").append(header.getValue());
        }
    }

    private final class LoggingConnection
    implements Connection {
        private final Connection connection;

        private LoggingConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        public CompletionStage<Void> accept(RsStatus status, Headers headers, Publisher<ByteBuffer> body) {
            StringBuilder msg = new StringBuilder("<< ").append((Object)status);
            LoggingSlice.append(msg, headers);
            Logger.log((Level)LoggingSlice.this.level, (Object)LoggingSlice.this.slice, (String)msg.toString(), (Object[])new Object[0]);
            return this.connection.accept(status, headers, body);
        }
    }
}

