/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import com.artipie.http.auth.AuthScheme;
import com.artipie.http.auth.Authentication;
import com.artipie.http.headers.Authorization;
import com.artipie.http.rq.RqHeaders;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class BasicAuthScheme
implements AuthScheme {
    public static final String NAME = "Basic";
    private final Authentication auth;

    public BasicAuthScheme(Authentication auth) {
        this.auth = auth;
    }

    @Override
    public CompletionStage<AuthScheme.Result> authenticate(Iterable<Map.Entry<String, String>> headers) {
        return CompletableFuture.completedFuture(this.user(headers).map(Success::new).orElseGet(() -> new Failure()));
    }

    private Optional<Authentication.User> user(Iterable<Map.Entry<String, String>> headers) {
        return new RqHeaders(headers, "Authorization").stream().findFirst().map(Authorization::new).filter(hdr -> hdr.scheme().equals(NAME)).map(hdr -> new Authorization.Basic(hdr.credentials())).flatMap(hdr -> this.auth.user(hdr.username(), hdr.password()));
    }

    private static class Failure
    implements AuthScheme.Result {
        private Failure() {
        }

        @Override
        public Optional<Authentication.User> user() {
            return Optional.empty();
        }

        @Override
        public String challenge() {
            return BasicAuthScheme.NAME;
        }
    }

    private static class Success
    implements AuthScheme.Result {
        private final Authentication.User usr;

        Success(Authentication.User user) {
            this.usr = user;
        }

        @Override
        public Optional<Authentication.User> user() {
            return Optional.of(this.usr);
        }

        @Override
        public String challenge() {
            return BasicAuthScheme.NAME;
        }
    }
}

