/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.auth;

import com.artipie.http.auth.Authentication;

public interface Permissions {
    public static final Authentication.User ANY_USER = new Authentication.User("*");
    public static final Permissions FREE = (name, action) -> true;

    public boolean allowed(Authentication.User var1, String var2);

    public static final class Single
    implements Permissions {
        private final String username;
        private final String action;

        public Single(String username, String allowed) {
            this.username = username;
            this.action = allowed;
        }

        @Override
        public boolean allowed(Authentication.User user, String act) {
            return this.username.equals(user.name()) && this.action.equals(act);
        }
    }

    public static abstract class Wrap
    implements Permissions {
        private final Permissions origin;

        protected Wrap(Permissions origin) {
            this.origin = origin;
        }

        @Override
        public final boolean allowed(Authentication.User user, String action) {
            return this.origin.allowed(user, action);
        }
    }
}

