/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.group;

import com.artipie.http.Connection;
import com.artipie.http.group.GroupResult;
import com.artipie.http.rs.StandardRs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class GroupResults {
    private final List<GroupResult> list;
    private final CompletableFuture<Void> future;

    GroupResults(int cap, CompletableFuture<Void> future) {
        this(new ArrayList<Object>(Collections.nCopies(cap, null)), future);
    }

    private GroupResults(List<GroupResult> list, CompletableFuture<Void> future) {
        this.list = list;
        this.future = future;
    }

    public CompletionStage<Void> complete(int order, GroupResult result, Connection con) {
        if (this.future.isDone()) {
            result.cancel();
            return CompletableFuture.completedFuture(null);
        }
        if (order >= this.list.size()) {
            throw new IllegalStateException("Wrong order of result");
        }
        this.list.set(order, result);
        for (int pos = 0; pos < this.list.size(); ++pos) {
            GroupResult target = this.list.get(pos);
            if (target == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (!target.success()) continue;
            return target.replay(con).thenRun(() -> this.list.stream().filter(Objects::nonNull).forEach(GroupResult::cancel)).thenRun(() -> this.future.complete(null));
        }
        return StandardRs.NOT_FOUND.send(con).thenRun(() -> this.future.complete(null));
    }
}

