/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.headers;

import com.artipie.http.Headers;
import com.artipie.http.headers.Header;
import com.artipie.http.rq.RqHeaders;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cactoos.text.Base64Decoded;
import org.cactoos.text.Base64Encoded;

public final class Authorization
extends Header.Wrap {
    public static final String NAME = "Authorization";
    private static final Pattern VALUE = Pattern.compile("(?<scheme>[^ ]+) (?<credentials>.+)");

    public Authorization(String scheme, String credentials) {
        super(new Header(NAME, String.format("%s %s", scheme, credentials)));
    }

    public Authorization(String value) {
        super(new Header(NAME, value));
    }

    public Authorization(Headers headers) {
        this(new RqHeaders.Single(headers, NAME).asString());
    }

    public String scheme() {
        return this.matcher().group("scheme");
    }

    public String credentials() {
        return this.matcher().group("credentials");
    }

    private Matcher matcher() {
        String value = this.getValue();
        Matcher matcher = VALUE.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalStateException(String.format("Failed to parse header value: %s", value));
        }
        return matcher;
    }

    public static final class Bearer
    extends Header.Wrap {
        public Bearer(String token) {
            super(new Authorization("Bearer", token));
        }

        public String token() {
            return new Authorization(this.getValue()).credentials();
        }
    }

    public static final class Basic
    extends Header.Wrap {
        public Basic(String username, String password) {
            this(new Base64Encoded(String.format("%s:%s", username, password)).toString());
        }

        public Basic(String credentials) {
            super(new Authorization("Basic", credentials));
        }

        public String credentials() {
            return new Authorization(this.getValue()).credentials();
        }

        public String username() {
            return this.tokens()[0];
        }

        public String password() {
            return this.tokens()[1];
        }

        private String[] tokens() {
            return new Base64Decoded(this.credentials()).toString().split(":");
        }
    }
}

