/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.headers;

import com.artipie.http.Headers;
import com.artipie.http.headers.Header;
import com.artipie.http.rq.RqHeaders;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContentDisposition
extends Header.Wrap {
    public static final String NAME = "Content-Disposition";
    private static final Pattern DIRECTIVES = Pattern.compile("(?<key> \\w+ ) (?:= [\"] (?<value> [^\"]+ ) [\"] )?[;]?", 4);
    private final Map<String, String> directives = this.parse();

    public ContentDisposition(String value) {
        super(new Header(NAME, value));
    }

    public ContentDisposition(Headers headers) {
        this(new RqHeaders.Single(headers, NAME).asString());
    }

    public String fileName() {
        return this.directives.get("filename");
    }

    public String fieldName() {
        return this.directives.get("name");
    }

    public Boolean isInline() {
        return this.directives.containsKey("inline");
    }

    public Boolean isAttachment() {
        return this.directives.containsKey("attachment");
    }

    private Map<String, String> parse() {
        Matcher matcher = DIRECTIVES.matcher(this.getValue());
        HashMap<String, String> values = new HashMap<String, String>();
        while (matcher.find()) {
            values.put(matcher.group("key"), matcher.group("value"));
        }
        return values;
    }
}

