/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.misc;

import com.artipie.http.misc.BufAccumulator;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ByteBufferTokenizer
implements Closeable {
    private static final ByteBuffer EMPTY_BUF = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private static final int CAP_DEFAULT = 4096;
    private final byte[] delim;
    private final Receiver receiver;
    private final BufAccumulator acc;

    public ByteBufferTokenizer(Receiver receiver, byte[] delim) {
        this(receiver, delim, 4096);
    }

    public ByteBufferTokenizer(Receiver receiver, byte[] delim, int cap) {
        this.receiver = receiver;
        this.delim = Arrays.copyOf(delim, delim.length);
        this.acc = new BufAccumulator(cap);
    }

    public void push(ByteBuffer chunk) {
        int bid;
        if (this.acc.write(chunk) <= 0) {
            return;
        }
        byte[] arr = this.acc.array();
        int offset = 0;
        while ((bid = ByteBufferTokenizer.indexOf(offset, arr, this.delim)) >= 0) {
            if (bid == 0) {
                this.receiver.receive(EMPTY_BUF, true);
                offset = this.delim.length;
                continue;
            }
            this.receiver.receive(this.acc.copyRange(offset, bid), true);
            offset = bid + this.delim.length;
        }
        int margin = arr.length - this.delim.length + 1;
        if (margin > 0) {
            if (offset < margin) {
                this.receiver.receive(this.acc.copyRange(offset, margin), false);
                this.acc.drop(margin);
            } else {
                this.acc.drop(offset);
            }
        }
    }

    @Override
    public void close() {
        this.flush();
        this.acc.close();
    }

    private void flush() {
        ByteBuffer dup = this.acc.duplicate();
        dup.flip();
        if (dup.hasRemaining()) {
            this.receiver.receive(this.acc.copyRange(dup.position(), dup.limit()), true);
        } else {
            this.receiver.receive(EMPTY_BUF, true);
        }
    }

    private static int indexOf(int offset, byte[] array, byte[] token) {
        int res = -1;
        for (int i = offset; i < array.length - token.length + 1; ++i) {
            boolean found = true;
            for (int j = 0; j < token.length; ++j) {
                if (array[i + j] == token[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            res = i;
            break;
        }
        return res;
    }

    @FunctionalInterface
    public static interface Receiver {
        public void receive(ByteBuffer var1, boolean var2);
    }
}

