/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.misc;

import com.artipie.http.misc.DummySubscription;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class Pipeline<D>
implements Subscriber<D>,
Subscription {
    private final Object lock = new Object();
    private volatile Subscriber<? super D> downstream;
    private volatile Subscription upstream;
    private volatile boolean completed;
    private volatile Throwable error;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Subscriber<? super D> sub) {
        Object object = this.lock;
        synchronized (object) {
            if (this.downstream != null) {
                sub.onSubscribe((Subscription)DummySubscription.VALUE);
                sub.onError((Throwable)new IllegalStateException("Downstream already connected"));
                return;
            }
            if (this.completed && this.error == null) {
                sub.onSubscribe((Subscription)DummySubscription.VALUE);
                sub.onComplete();
            } else if (this.error != null) {
                sub.onSubscribe((Subscription)DummySubscription.VALUE);
                sub.onError(this.error);
            } else {
                this.downstream = sub;
                this.checkRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        Object object = this.lock;
        synchronized (object) {
            if (this.downstream == null) {
                this.completed = true;
            } else {
                this.downstream.onComplete();
            }
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable err) {
        Object object = this.lock;
        synchronized (object) {
            if (this.downstream == null) {
                this.completed = true;
                this.error = err;
            } else {
                this.downstream.onError(err);
            }
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(D item) {
        Object object = this.lock;
        synchronized (object) {
            assert (this.downstream != null);
            this.downstream.onNext(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription sub) {
        Object object = this.lock;
        synchronized (object) {
            if (this.upstream != null) {
                throw new IllegalStateException("Can't subscribe twice");
            }
            this.upstream = sub;
            this.checkRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cleanup();
        }
    }

    public void request(long amt) {
        assert (this.downstream != null && this.upstream != null);
        this.upstream.request(amt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRequest() {
        Object object = this.lock;
        synchronized (object) {
            if (this.downstream != null && this.upstream != null) {
                this.downstream.onSubscribe((Subscription)this);
                this.upstream.request(1L);
            }
        }
    }

    private void cleanup() {
        if (this.upstream != null) {
            this.upstream.cancel();
        }
        this.upstream = null;
        this.downstream = null;
    }
}

