/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.http.rq.multipart;

import com.artipie.http.ArtipieHttpException;
import com.artipie.http.Headers;
import com.artipie.http.headers.ContentType;
import com.artipie.http.rq.multipart.MultiParts;
import com.artipie.http.rs.RsStatus;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import wtf.g4s8.mime.MimeType;

public final class RqMultipart {
    private ContentType ctype;
    private Publisher<ByteBuffer> upstream;

    public RqMultipart(Headers headers, Publisher<ByteBuffer> body) {
        this(new ContentType(headers), body);
    }

    public RqMultipart(ContentType ctype, Publisher<ByteBuffer> body) {
        this.ctype = ctype;
        this.upstream = body;
    }

    public Publisher<Part> parts() {
        MultiParts pub = new MultiParts(this.boundary());
        pub.subscribeAsync(this.upstream);
        return pub;
    }

    private String boundary() {
        String header = (String)MimeType.of((CharSequence)this.ctype.getValue()).param("boundary").orElseThrow(() -> new ArtipieHttpException(RsStatus.BAD_REQUEST, "Content-type boundary param missed"));
        return String.format("\r\n--%s", header);
    }

    public static interface Part
    extends Publisher<ByteBuffer> {
        public Headers headers();
    }
}

